/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.schematics.Blueprint;
import noppes.npcs.schematics.BlueprintUtil;
import noppes.npcs.schematics.ISchematic;
import noppes.npcs.schematics.Schematic;
import noppes.npcs.schematics.SchematicWrapper;
import noppes.npcs.util.Util;

public class SchematicController {
    public static SchematicController Instance = new SchematicController();
    public static long time = 50L;
    public static final List<String> included = Arrays.asList("archery_range.schematic", "bakery.schematic", "barn.schematic", "building_site.schematic", "chapel.schematic", "church.schematic", "gate.schematic", "glassworks.schematic", "guard_Tower.schematic", "guild_house.schematic", "house.schematic", "house_small.schematic", "inn.schematic", "library.schematic", "lighthouse.schematic", "mill.schematic", "observatory.schematic", "ship.schematic", "shop.schematic", "stall.schematic", "stall2.schematic", "stall3.schematic", "tier_house1.schematic", "tier_house2.schematic", "tier_house3.schematic", "tower.schematic", "wall.schematic", "wall_corner.schematic");
    private final List<SchematicWrapper> buildingList = new ArrayList<SchematicWrapper>();
    public Map<String, SchematicWrapper> map = new HashMap<String, SchematicWrapper>();
    private final char chr = (char)167;

    public static void buildBlocks(EntityPlayerMP player, BlockPos pos, int rotation, Schematic schema) {
        if (player == null || pos == null || schema == null) {
            return;
        }
        long ticks = 3000L + (long)schema.blockIdsArray.length * time + (long)Math.floor((double)schema.blockIdsArray.length / (double)CustomNpcs.MaxBuilderBlocks) * 1000L;
        player.func_145747_a((ITextComponent)new TextComponentTranslation("schematic.info.started", new Object[]{schema.name, "" + pos.func_177958_n(), "" + pos.func_177956_o(), "" + pos.func_177952_p(), Util.instance.ticksToElapsedTime(ticks, true, true, false)}));
        SchematicWrapper sw = new SchematicWrapper(schema);
        sw.init(pos.func_177974_f().func_177968_d(), player.field_70170_p, rotation * 90);
        Instance.build(sw, (ICommandSender)player);
    }

    public static File getDir() {
        File schematicDir = new File(CustomNpcs.getWorldSaveDirectory(), "schematics");
        File saveDir = CustomNpcs.getWorldSaveDirectory();
        while (saveDir.getParentFile() != null) {
            if (!new File(saveDir = saveDir.getParentFile(), "config").exists()) continue;
            schematicDir = new File(saveDir, "schematics");
            break;
        }
        if (!schematicDir.exists()) {
            schematicDir.mkdir();
        }
        return schematicDir;
    }

    public void build(SchematicWrapper schema, ICommandSender sender) {
        if (schema == null) {
            this.sendMessage(sender, "schematic.info.notbuild", new Object[0]);
            return;
        }
        if (this.buildingList.contains(schema)) {
            this.sendMessage(sender, "schematic.info.already", this.chr + "7" + schema.schema.getName(), this.chr + "7" + schema.getPercentage(), this.chr + "7%");
            if (schema.sender != null) {
                this.sendMessage(sender, "schematic.info.start.name", this.chr + "7" + schema.sender.func_70005_c_());
            }
            return;
        }
        schema.setBuilder(sender);
        this.buildingList.add(schema);
    }

    public SchematicWrapper getSchema(String name) {
        if (!this.map.containsKey(name.toLowerCase())) {
            this.load(name.toLowerCase());
        }
        return this.map.get(name.toLowerCase());
    }

    public void info(ICommandSender sender) {
        if (this.buildingList.isEmpty()) {
            this.sendMessage(sender, "schematic.info.empty", new Object[0]);
            return;
        }
        for (SchematicWrapper sm : this.buildingList) {
            this.sendMessage(sender, "schematic.info.0", this.chr + "7" + sm.schema.getName(), this.chr + "7" + sm.getPercentage(), this.chr + "7%", sm.sender == null ? "" : new TextComponentTranslation("schematic.info.1", new Object[0]).func_150254_d());
        }
    }

    public List<String> list() {
        ArrayList<String> list = new ArrayList<String>(included);
        for (File file : Objects.requireNonNull(SchematicController.getDir().listFiles())) {
            String name = file.getName();
            if (!name.toLowerCase().endsWith(".schematic") && !name.toLowerCase().endsWith(".blueprint")) continue;
            list.add(name);
        }
        Collections.sort(list);
        return list;
    }

    public SchematicWrapper load(String name) {
        CustomNpcs.debugData.start(null);
        InputStream stream = null;
        if (included.contains(name)) {
            stream = MinecraftServer.class.getResourceAsStream("/assets/customnpcs/schematics/" + name);
        }
        if (stream == null) {
            File file = new File(SchematicController.getDir(), name);
            if (!file.exists()) {
                for (File f : Objects.requireNonNull(SchematicController.getDir().listFiles())) {
                    if (!f.getName().equalsIgnoreCase(name)) continue;
                    file = f;
                    break;
                }
            }
            if (!file.exists()) {
                CustomNpcs.debugData.end(null);
                return null;
            }
            try {
                stream = new FileInputStream(file);
            }
            catch (FileNotFoundException e2) {
                CustomNpcs.debugData.end(null);
                return null;
            }
        }
        SchematicWrapper schemaWr = null;
        try {
            Blueprint bp;
            NBTTagCompound compound = CompressedStreamTools.func_74796_a(stream);
            stream.close();
            if (name.toLowerCase().endsWith(".blueprint") && (bp = BlueprintUtil.readBlueprintFromNBT(compound)) != null) {
                bp.setName(name);
                schemaWr = new SchematicWrapper(bp);
            }
            if (schemaWr == null) {
                Schematic schema = new Schematic(name);
                schema.load(compound);
                schemaWr = new SchematicWrapper(schema);
            }
        }
        catch (IOException e) {
            LogWriter.except(e);
        }
        if (schemaWr != null) {
            this.map.put(name.toLowerCase(), schemaWr);
        }
        CustomNpcs.debugData.end(null);
        return schemaWr;
    }

    public void save(ICommandSender sender, String name, int type, BlockPos pos, short height, short width, short length) {
        CustomNpcs.debugData.start(null);
        name = name.replace(" ", "_");
        if (included.contains(name)) {
            CustomNpcs.debugData.end(null);
            return;
        }
        World world = sender.func_130014_f_();
        File file = null;
        ISchematic schema = null;
        if (type == 0) {
            file = new File(SchematicController.getDir(), name + ".schematic");
            schema = Schematic.create(world, name, pos, height, width, length);
        } else if (type == 1) {
            file = new File(SchematicController.getDir(), name + ".blueprint");
            schema = BlueprintUtil.createBlueprint(world, pos, width, length, height);
        }
        TextComponentString message = new TextComponentString("Schematic " + name + " successfully created");
        message.func_150256_b().func_150238_a(TextFormatting.GRAY);
        NoppesUtilServer.NotifyOPs((ITextComponent)message, false);
        try {
            if (schema != null) {
                CompressedStreamTools.func_74799_a((NBTTagCompound)schema.getNBT(), (OutputStream)Files.newOutputStream(file.toPath(), new OpenOption[0]));
            }
        }
        catch (Exception e) {
            LogWriter.error(e);
        }
        CustomNpcs.debugData.end(null);
    }

    private void sendMessage(ICommandSender sender, String message, Object ... objs) {
        if (sender == null) {
            return;
        }
        sender.func_145747_a((ITextComponent)new TextComponentTranslation(message, objs));
    }

    public void stop(ICommandSender sender) {
        if (this.buildingList.isEmpty()) {
            this.sendMessage(sender, "schematic.info.build.empty", new Object[0]);
        } else {
            StringBuilder smts = new StringBuilder();
            for (SchematicWrapper sm : this.buildingList) {
                if (smts.length() > 0) {
                    smts.append(";\n");
                }
                smts.append(this.chr).append("7\"").append(sm.schema.getName()).append("\" in [").append(sm.start.func_177958_n()).append(", ").append(sm.start.func_177956_o()).append(", ").append(sm.start.func_177952_p()).append("]");
            }
            this.sendMessage(sender, "schematic.info.build.stop", smts.toString());
            this.buildingList.clear();
        }
    }

    public void updateBuilding() {
        if (this.buildingList.isEmpty()) {
            return;
        }
        CustomNpcs.debugData.start(null);
        ArrayList<SchematicWrapper> del = new ArrayList<SchematicWrapper>();
        for (SchematicWrapper sm : this.buildingList) {
            sm.build();
            if (sm.sender != null && sm.getPercentage() - sm.buildingPercentage >= 10) {
                this.sendMessage(sm.sender, "schematic.info.build.percentage", this.chr + "7" + sm.schema.getName(), this.chr + "7" + sm.getPercentage(), this.chr + "7%");
                sm.buildingPercentage = sm.getPercentage();
            }
            if (sm.isBuilding) continue;
            if (sm.sender != null) {
                if (sm.schema.hasEntitys()) {
                    this.sendMessage(sm.sender, "schematic.info.spawn.entitys", this.chr + "7" + sm.schema.getName());
                }
                this.sendMessage(sm.sender, "schematic.info.build.finish", this.chr + "7" + sm.schema.getName());
            }
            del.add(sm);
        }
        for (SchematicWrapper sm : del) {
            this.buildingList.remove(sm);
        }
        CustomNpcs.debugData.end(null);
    }
}

